function zoomimage(imcoarse, imfine, mag,area)
% zoomimage(coarse, fine, mag, area)
% zoom in on one image based on a selection
% of a point in another
% mag --- how many pixels in fine
%         correspond to one pixel in coarse
% area --- how many pixels in coarse to 
%          zoom in on
[svert,shoriz] = size(imcoarse);
[fvert,fhoriz] = size(imfine);

ptr1 = figure(1);
imshow(imcoarse);
bound = line([0 0], [0 0]);
while 1
   disp('Double-click on pixel (or cntr-c)');
   [x,y] = getpts(ptr1);
   x = min(max(1,floor(x(length(x)))),shoriz);
   y = min(max(1,floor(y(length(y)))),svert);
   % get the coordinates in the fine image
   xx = mag*x;
   yy = mag*y;
   % pick a region that is area/2 on each side of xx
   lowxx = max(1,floor(xx - area/2));
   highxx = min(fhoriz,floor(xx + area/2));
   lowyy = max(1,floor(yy - area/2));
   highyy = min(fvert, floor(yy+area/2));
   figure(2);
   imshow(imfine(lowyy:highyy, lowxx:highxx));
   figure(1);
   set(bound,'xdata',[lowxx lowxx highxx highxx lowxx]/mag);
   set(bound,'ydata',[lowyy highyy highyy lowyy lowyy]/mag);
end


   
