% [arith,geom] = twomeans(a,b)
% Computes the arithmetical and geometrical means 
% of the two scalar, numerical arguments. 
% Example: [a,g] = twomeans(1,4) gives a->2.5, g->2
function [arith, geom] = twomeans(a,b) 
arith = (a + b)./2; %! Arithmetic mean is $\frac{a+b}{2}$
geom  = sqrt( a.*b ); %! Geometric mean is $\sqrt{a b}$
