% test primefactors on n random inputs
% return inputs for which the answer was wrong
% or an error was generated
function res = testprimefactors(n)
res = [];
edgecases = [-1 0 1 2 -10 4.1];
randomcases = floor(1000000000000*rand(1,n)); %! Round to integers

for k = [edgecases randomcases]  
   try
      factors = primefactors(k);
      if prod(factors) ~= k %! Test for wrong answer
         res = [res k]; 
      end
   catch
      res = [res k]; %! An error was generated
   end
end
