function res = showca(initial, niters)
% showca(initial, niters)
% Iterate a 1-dim cellular automaton, plotting the result
res = zeros(niters+1, length(initial));%! Create a matrix to hold the evolving state. 
res(1,:) = initial; %! Fill in the first row.
for k=1:niters %! Iterate the CA
    initial = caiter(initial); %! Update the state.
    res(k+1,:) = initial;%! Fill in the appropriate row. 
end 
pcolor(1:length(initial), 0:niters, res); %! Plot out the state over time.
colormap(1-gray); %! Draw 1 as black and 0 as white
shading('flat');
xlabel('Position');
ylabel('Time steps');
axis ij % Arrange for 0 to be at the top.