% draw the figure relating to digitizing precision

%The signal is samples 700-850 of the oh.wav
[y,fs,b] = wavread('oh.wav');
yy = y(700:850);
tt = 1000*(0:150)./fs;

% scale yy to cover the range -5 to 5 Volts, imagining that it
% is at half that amplitude
figure(1);
yv = 6*yy;
subplot(2,2,1);
plot(tt,yv);
ylim([-5 5]);
ylabel('Voltage');

subplot(2,2,2);
plot( floor(yv*127./5), '.' );
ylim([-128 127]);
ylabel('A/D units');

yv = .3*yy;
subplot(2,2,3);
plot(tt,yv);
ylim([-5 5]);
ylabel('Voltage');
xlabel('Time (msec)');

subplot(2,2,4);
plot( floor(yv*127./5), '.' );
ylim([-8 8]);
ylabel('A/D units');
xlabel('Time (samples)');


figure(2);
subplot;
yv = 17*yy;
samples = floor(yv*127./5);
samplesclipped = max(min(samples,127),-128);
yvclipped = max(min(yv,5),-5);
[haxes,hline1, hline2] = plotyy(tt,yv,tt,samples);
axes(haxes(1));
ylim([-10 10]);
ylabel('Voltage');
set(haxes(1), 'YTick', [-5, 0, 5]);
axes(haxes(2));
ylabel('A/D units');
ylim([-256 256]);
set(hline2,'Marker','.', 'Linestyle', '.', 'MarkerSize', 12)
set(haxes(2), 'YTick', [-128, 0, 127]);
xlabel('Time (msec)');

figure(3);
subplot;
yv = 17*yy;
samples = floor(yv*127./5);
samples = min(samples,127);
samples = max(samples, -128);
[haxes,hline1, hline2] = plotyy(tt,yvclipped,tt,samplesclipped);
axes(haxes(1));
ylim([-10 10]);
ylabel('Voltage');
set(haxes(1), 'YTick', [-5, 0, 5]);
axes(haxes(2));
ylabel('A/D units');
ylim([-256 256]);
set(hline2,'Marker','.', 'Linestyle', '.', 'MarkerSize', 12)
set(haxes(2), 'YTick', [-128, 0, 127]);
xlabel('Time (msec)');
