function res = readbridge(name)
% readbridge(name)
% read in the bridge specification from the data files starting with 'name'
% e.g., name = 'truss5';
% nodes --- node #, xpos, ypos
% beams --- bean #, node1, node2, mass
% supports --- first gives node with vertical support
%              second gives other node with vertical support
%              third gives node with horizontal support
% loads --- node #, load on that noad

nodes = load([name 'nodes.dat']);
beams = load([name 'beams.dat']);
support = load([name 'supports.dat']);
loads = load([name 'loads.dat']);

res.nodelist = nodes(:,1);
res.nodex = nodes(:,2);
res.nodey = nodes(:,3);
res.beamlist = beams(:,1);
res.beamnode1 = beams(:,2);
res.beamnode2 = beams(:,3);
res.beammass = beams(:,4);
res.supports = support(:,1);
res.supportdir = support(:,2);
res.loadsx = loads(:,2);
res.loadsy = loads(:,3);
res.tensions = ones(size(res.beamlist));

% check for inconsistencies
if loads(:,1) ~= res.nodelist
   error('Loads in loads.dat are not in the same order as the nodes in nodes.dat');
end

if max(res.beamnode1) > max(res.nodelist) | max(res.beamnode2) > max(res.nodelist)
   error('Nodes in beams.dat are not the same as the nodes in nodes.dat');
end

