function res = puretone(sf, freq, dur, amp, slurr)
% puretone(sf,freq,dur,amp,slurr) - DTK
% generate a single note for playmusic
% sf --- the sampling frequency
% dur --- duration of the note in seconds
% amp --- amplitude of the note
% slurr -- an unused argument
%
% Any note-generating function that works with playmusic must
% accept these five arguments in this order.
times = [(1/sf):(1/sf):dur]';
if isnan(freq)
    res = zeros(size(times));
else
    res = sin(2*pi*freq*times)*amp;
end

if ~slurr
    % make the first 0.1 secs a ramp up.
    ramp = (1:(0.1*sf))';
    res(ramp) = res(ramp).*ramp/(0.1*sf);
end

% trim the end gradually
% .02 seconds ramp down
d = .02;
n = floor(d.*sf);
env = linspace(1,0,n+1)';
res((end-n):end) = res((end-n):end).*env;
