% load in the data and plot them    %! A comment line
d = importdata('sunspots.csv');     %! spreadsheet w/ header
x = d.data; % just the numerical part of sunspots.csv
% The first column is the year 
year = x(:,1); 
% The second column is the months
month = x(:,2);
% The third is the number of spots 
spots = x(:,3);
% Compute the date as year + fraction
time = year + (month-.5)./12;
plot(time,spots); %! Plotting the data
title('Sunspot Counts'); %! Add a title
xlabel('Year');  %! and labels
ylabel('# of Sunspots');  