function playalias(analogfreq, sampfreq, phi)
playfreq = 8192.*2;
if sampfreq > playfreq
   error(['sampfreq must be less than ' num2str(playfreq) 'Hz']);
end

if nargin < 3
   phi = .1;
end

duration = 1;
samptimes = 0:(1/sampfreq):duration;
finetimes = 0:(1/playfreq):duration;
samps = .5*sin(2*pi*analogfreq*samptimes+ phi);
y = interp1(samptimes, samps, finetimes);
sound(y,playfreq);

