function res = pipetone(sf, freq, dur, amp, slurr)
persistent snd;
persistent sndsf; % sampling frequency
persistent samptimes;
persistent basefreq;

if isempty(snd)
    [snd,sndsf] = wavread('pipe.wav');
    samptimes = (1:length(snd))./sndsf;
    basefreq = 880;
end

times = (((2/sf):(1/sf):dur)*(freq/basefreq))';
if isnan(freq)
    res = zeros(size(times));
else
    res = interp1(samptimes,snd,times);
end

% smooth the end
% get the last 20th of a second
% time constant = .025 sec
% duration = 0.1;
tc = 0.02; % time constant
decaydur = 0.125; % duration of decay
starttransient = floor(length(res) - sf*decaydur);
transientsamps = [starttransient:length(res)]';
factor = exp(-(transientsamps-starttransient)/(tc*sf));

res(transientsamps) = res(transientsamps).*factor;
% trim the end gradually
% .01 seconds ramp down
d = .01;
n = floor(d.*sf);
env = linspace(1,0,n+1)';
res((end-n):end) = res((end-n):end).*env;

% trim up the start
n = 1000;
env = linspace(0,1,n)';
res(1:n) = res(1:n).*(env.^4);

