function T = newtonCooling(T0, Tenv, k, time)
% newtonCooling(T0, Tenv, k, time)
% Temperature of a cooling object at any given time
% T0 --- object's temperature at time 0
% Tenv --- environment's temperature
% k --- time constant of exponential cooling
% time --- the time  
T = Tenv + (T0 - Tenv).*exp(-k.*time); %! From Eq. \ref{eq:coffee-cooling}