function mandelbrotgui
% mandelbrotGUI: graphical user interface
stack = {[-1.8,1.8,-1.3,1.3]};
f = figure; %! Bring up a figure.
while 1
    coords = stack{end};
    drawMandelbrot(coords(1:2), coords(3:4));
    choice = menu('Which one?', ... %! Menu input
        'Zoom', 'Pan Out', 'Quit'); 
    switch choice
    case 1
        m = getrect(gca); %! Mouse input
        stack{end+1} = newcoords(m); %! Push.
    case 2 
        if length(stack) > 1 %! Is there something to pop?
            stack = stack(1:(end-1)); %! Then pop.
        else 
            stack{1}=expandview(stack{1}); 
        end
    case 3
        break;
    end 
end

function res = newcoords(m)%! Subfunction
res = [m(1), m(1)+m(3), m(2), m(2)+m(4)];
function res = expandview(coords)%! Subfunction
midx = mean(coords(1:2));
midy = mean(coords(3:4));
lenx = abs(diff(coords(1:2)));
leny = abs(diff(coords(3:4)));
res=[midx+lenx*[-1,1], midy+leny*[-1,1]];