function res = image2double(im)

switch class(im)
case 'double'
   if max(max(max(im))) > 1 | min(min(min(im))) < 0
      warning('Images should be scaled [0,1].  This one isn''t.');
   end
   res = im;
case 'uint8'
   res = double(im)/255;
case 'uint16'
   res = double(im)/65535;
otherwise
   error('Unrecognized type for image matrix.');
end

   