function [spts,tpts] = identPts(source,target)
% identPts(source,target) -- GUI for marking corresponding points
% in two images. Returns:
% spts --- (x,y) coordinates of the points in the source image
% tpts --- (u,v) coordinates of the points in the target image
% Mouse-clicking in the image window will mark and number the point
% IT IS UP TO YOU TO MAKE SURE THAT THE POINTS MARKED IN THE
% TWO IMAGES CORRESPOND, AND THAT THERE ARE THE SAME NUMBER OF
% POINTS MARKED IN EACH IMAGE.
%
% Controls: pressing a key causes something to happen:
% t -- raises the target image
% s -- raises the source image
% d -- deletes the last point marked in whatever image is raised
% q -- indicates that you are finished.

sfig = 1; % Figure windows
tfig = 2; 

currentactive=1;
nptsmax = 30;
spts = [];
tpts = [];

figure(sfig);
image(source);
title('Source');
set(gca,'UserData','source');
hold on;
spthandle = plot(1,1,'.');
hold off
for k=1:nptsmax
    stext(k) = text(0,0,'','Visible', 'off');
    
end


figure(tfig);
image(target)
title('Target');
set(gca, 'UserData', 'target');
hold on;
tpthandle = plot(1,1,'.');
hold off;
for k=1:nptsmax
    ttext(k) = text(0,0,'','Visible', 'off');
end

while 1
    figure(currentactive);
    type = waitforbuttonpress;
    if type == 0 % mouse
        ff = get(gca,'UserData');
        switch ff
        case 'source'
            currentactive = sfig;
        case 'target'
            currentactive = tfig;
        end
        p = get(gca,'CurrentPoint');
        if currentactive == tfig
            tpts = [tpts;[p(1,1:2)]];
            
        elseif currentactive == sfig
            spts = [spts;[p(1,1:2)]];
            
        end
    
        
    else % keyboard
        c = get(gcf,'CurrentChar');
        switch c
        case 't'
            currentactive = tfig;
        case 's'
            currentactive = sfig;
        case 'd'
            if currentactive == sfig
                if ~isempty(spts)
                    spts = spts(1:end-1,:);
                end
            elseif currentactive == tfig
                if ~isempty(tpts)
                    tpts = tpts(1:end-1,:);
                end
            end
        case 'q'
            break;
        end
    end
    % plot the points
    if isempty(spts)
        set(spthandle,'Xdata', [], 'Ydata', []);
    else
        set(spthandle,'Xdata',spts(:,1), 'Ydata', spts(:,2));
        [r,c] = size(spts);
        for k=1:r
            set(stext(k),'Position', [spts(k,1), spts(k,2), 0], ...
                'String', num2str(k), 'Visible', 'on');
        end
        for k=(r+1):nptsmax
            set(stext(k),'Visible', 'off');
        end
    end
    if isempty(tpts)
        set(tpthandle,'Xdata', [], 'Ydata', []);
    else
        set(tpthandle,'Xdata',tpts(:,1), 'Ydata', tpts(:,2));
    end
    [r,c] = size(tpts);
    for k=1:r
        set(ttext(k),'Position', [tpts(k,1), tpts(k,2), 0], ...
            'String', num2str(k), 'Visible', 'on');
    end
    for k=(r+1):nptsmax
        set(ttext(k),'Visible', 'off');
    end
end
