function res = equalize(im, mixture)
% histogram equalization of an image plane
% im -- the image: a single plane
% mixture -- optional, mix the equalized and 
%  original with this proportion of the original
if nargin < 2
   mixture = 1;
end
if mixture < 0 | mixture > 1
   error('mixture must be between 0 and 1');
end

res = im;
[foo,index] = sort(im(:));
n = prod(size(im));
res(index) = (1:n)./n;
res = (mixture*res+(1-mixture)*im);