function ecgplot

% plot information
sigwidth = 15; % centimeters
height = 5; % centimeters
calibwidth = 2; % calibration width in cm

% One time scale for all plots
timescale = 2.5; % centimeters/sec
% Separate amplitude scales (all in cm/(physical unit)) for each plot
ampscale = 1; % centimeters/mV for ECG
% Calibration pulse range 
calibrange = 1; % mV for ECG

% signal information
nsigs=2; % number of signals
sampfreq = 128; % sampling frequency
onemV=500; % D/A units per millivolt

% positioning the signals
% divide up the total range with signals spaced by 1 unit from the 
% edges and 2 from each other
unit = height./(2*nsigs);
position =  unit*cumsum([1, 2*ones(1, nsigs-1)]);

ecg = load('ecg.dat');
[npts, nsigs] = size(ecg);

% scale the signal 
sig = cell(1,nsigs);
for k = 1:nsigs
  sig{k} = ecg(:,k)/(onemV/ampscale); % scaled to cm
end
time = (0:(npts-1))/(sampfreq/timescale);% caled to cm

f = figure(1);
set(f, 'units', 'centimeters', ...
   'position', [0, 10, sigwidth+calibwidth+2, height+2]);
sigaxis = axes('units', 'centimeters', ...
   'position', [1+calibwidth, 1, sigwidth, height], ...
   'xlim', [0 sigwidth], ...
   'ylim', [0 height], ...
   'xtick', [], 'ytick', []);
calibaxis = axes('units', 'centimeters', ...
   'position', [1 1, calibwidth, height], ...
   'xlim', [0 1], ...
   'ylim', [0 height],...
   'xtick', [], 'ytick', []);
axes(sigaxis);

% make the grid dots
[xpts,ypts] = makedots(sigwidth, height, 0.1, 0.1);

griddots = line(xpts,ypts,'color', 'red', ...
   'linestyle', 'none', 'marker', '.', ...
   'markersize', 1);

% make the grid lines
[xpts,ypts] = makedots(sigwidth, height, sigwidth, .5);
gridxlines = line(reshape(xpts,2,length(xpts)./2), ...
   reshape(ypts,2,length(ypts)./2), ...
   'color', 'red');
[ypts,xpts] = makedots(height,sigwidth, height, .5);
gridxlines = line(reshape(xpts,2,length(xpts)./2), ...
   reshape(ypts,2,length(ypts)./2), ...
   'color', 'red');
% plot out the ecg signal
axes(sigaxis);
ecgline = cell(1,nsigs);
for k=1:nsigs
   ecgline{k} = line(time, ...
      sig{k}-mean(sig{k}) + position(k),...
      'color', 'black', 'linewidth', 1.4);
end
