function [xmin,ymin,xmax,ymax] = drawthing(drawitem,params)
% drawthing --- translate a drawitem into graphics primitives
% drawthing( drawitem ) 
% returns a bounding box containing the item

switch drawitem.type
case 'line'
   % .start gives x,y of startpoint, .finish gives x.y of endpoint
   xs = drawitem.start(1);
   ys = drawitem.start(2);
   xf = drawitem.finish(1);
   yf = drawitem.finish(2);
   plot([xs xf], [ys yf], 'LineWidth', params.linewidth);
   xmin = min(xs,xf);
   xmax = max(xs,xf);
   ymin = min(ys,yf);
   ymax = max(ys,yf);
case 'circle'
   % .start gives center, .finish gives radius
   npts = 50; % number of points in the circle
   radius = abs(drawitem.finish);
   x = drawitem.start(1) + radius.*cos(2*pi*(0:npts)/npts);
   y = drawitem.start(2) + radius.finish.*sin(2*pi*(0:npts)/npts);
   plot(x,y);
   % the bounding box of this object
   xmin = x-radius;
   xmax = x+radius;
   ymin = y - radius;
   ymax = y + radius;
case 'rectangle'
   % .start gives lower left corner, .finish gives upper right corner
   xleft = drawitem.start(1);
   ybottom = drawitem.start(2);
   xright = drawitem.finish(1);
   ytop = drawitem.finish(2);
   plot( [xleft xright xright xleft xleft], [ybottom ybottom ytop ytop ybottom]);
   % the bounding box of this object
   xmin = min(xright,xleft);
   xmax = max(xright,xleft);
   ymin = min(ytop,ybottom);
   ymax = max(ytop,ybottom);
case 'text'
   % .start gives position, .finish gives alignment, .text gives contents
   if isempty(drawitem.others)
      h = text(drawitem.start(1), drawitem.start(2), drawitem.text);
   else
      h = text( drawitem.start(1), drawitem.start(2), drawitem.text, ...
         drawitem.others{:});
   end
   
   % the bounding box of this object
   ex = get(h,'Extent');
   xmin = ex(1); xmax = ex(3); ymin=ex(2); ymax = ex(4);
   % the above will be incorrect if the axes are rescaled, but this will be
   % adequate for defining the bounding box
otherwise
   error('Unknown drawthing construction.');
end
