function drawbridge(bridge)

% plot out the node
plot(bridge.nodex, bridge.nodey,'o');
text(bridge.nodex+.03, bridge.nodey-.04, num2str(bridge.nodelist));

% plot out the beams
colormap('gray');
colors = flipud(colormap);
maxtension = max(abs(bridge.tensions));
compressionwidth=5;
tensionwidth=2;
colorlength=length(colormap);
for k=1:length(bridge.beamlist)
   beam = bridge.beamlist(k);
   node1 = bridge.beamnode1(k);
   node2 = bridge.beamnode2(k);
   x = bridge.nodex([node1 node2]);
   y = bridge.nodey([node1 node2]);
   foo = line(x,y);
   set(foo, 'color', ...
      colors( max(5,floor(colorlength*abs((bridge.tensions(k)/maxtension)))),:));
   if bridge.tensions(k) < 0
      % draw it as a thick line since the member is under compression
      set(foo, 'linewidth', compressionwidth);
   else
      set(foo,'linewidth',tensionwidth);
   end
   
   text(sum(x)/2, .04+sum(y)/2, num2str(bridge.beamlist(k)));
end

supportwidth=10;
% draw the vertical support
for k=1:3
   node = bridge.supports(k);
   x = bridge.nodex(node);
   y = bridge.nodey(node);
   if bridge.supportdir(k) == 0
      % vertical support
      foo = line( [x x],[y y-.1]);
   else
      foo = line( [x x-.1], [y y]);
   end
   set(foo, 'linewidth', 10);
end


axis([-.2+min(bridge.nodex) .2+max(bridge.nodex) ...
      -.2+min(bridge.nodey) .5+max(bridge.nodey)]);

axis('equal');