function res = conversionToMetersV2(unitname) 
switch lower(unitname)
case {'yards', 'yd'}
   %!! Does \code{unitname} match ``yards''
   res = 0.9144;
case {'inches', 'in'}   %! Similarly for ``inches''
   res = 0.0254;
case {'miles', 'mi'} %! and so on
   res = 1609.0;
case 'furlongs' 
   res = 201.125;
case 'light-years'
   res = 9.460913e15;
otherwise
   error('No conversion to meters known');
end
