function res = conversionToMetersV1(unitname)
% Return a conversion factor to meters for the given 
% character-string unitname
 
if strcmp(unitname, 'yards') | ...
        strcmp(unitname, 'yd')
   %!! Check for match to ``yards''
   res = 0.9144;
elseif strcmp(unitname, 'inches') | ...
        strcmp(unitname, 'in')
   %!! Similarly for ``inches''
   res = 0.0254;
elseif strcmp(unitname, 'miles') | ...
        strcmp(unitname, 'mi')
   res = 1609.0;
elseif strcmp(unitname, 'furlongs') 
   res = 201.125;
elseif strcmp(unitname, 'light-years')
   res = 9.460913e15;
else
   error('No conversion to meters known');
end
