%!! start: combwrapper
% combinations(k, n)
% All the ways of taking n items 
% out of a set of k items
function res = combinations(k, n) %! The wrapper function
res = helper(1:k,n,[]);
%!! end: combwrapper
%!! start: combhelper
% Helper function
function res = helper(set,n,accum) %! Recursive helper function.
if n > length(set) %! Base case: can't find $n$ items in set
   res = [];
elseif n==0  %! Base case: have already found $n$ items
   res = accum;
elseif n == length(set) %! Base case: the whole set is needed
   res = [accum, set];
else %! The two recursive branches
   a = helper(set(2:end),n-1,[accum, set(1)]); 
   %!! Those subsets with \code{set(1)}
   b = helper(set(2:end),n, accum);
   %!! Those subsets without \code{set(1)}
   res = [a; b]; 
   %!! Collect together the two types of subsets
end
%!! end:combhelper