function res = charToMorse( letter )
% charToMorse(letter) convert a single letter 
% to Morse code using the representation
% 1 == dot
% 2 == dash
% 3 == between components
% 4 == between letters
% 5 == between words
% 0 == meaningless
dot = 1;
dash = 2;
bc = 3;  % between components
betweenletters = 4;
betweenwords = 5;

switch char(upper(letter))
case 'A'
  res = [dot bc dash];
case 'B'
  res = [dash bc dot bc dot bc dot];
case 'C'
  res = [dash bc dot bc dash bc dot];
case 'D'
  res = [dash bc dot bc dot];
case 'E'
  res = dot;
case 'F'
  res = [dot bc dot bc dash bc dot];
case 'G'
  res = [dash bc dash bc dot];
case 'H'
  res = [dot bc dot bc dot bc dot];
case 'I'
  res = [dot bc dot];
case 'J'
  res = [dot bc dash bc dash bc dash];
case 'K'
  res = [dash bc dot bc dash];
case 'L'
  res = [dot bc dash bc dot bc dot];
case 'M'
  res = [dash bc dash];
case 'N'
  res = [dash bc dot];
case 'O'
  res = [dash bc dash bc dash];
case 'P'
  res = [dot bc dash bc dash bc dot];
case 'Q'
  res = [dash bc dash bc dot bc dash];
case 'R'
  res = [dot bc dash bc dot];
case 'S'
  res = [dot bc dot bc dot];
case 'T'
  res = dash;
case 'U'
  res = [dot bc dot bc dash];
case 'V'
  res = [dot bc dot bc dot bc dash];
case 'W'
  res = [dot bc dash bc dash];
case 'X'
  res = [dash bc dot bc dot bc dash];
case 'Y'
  res = [dash bc dot bc dash bc dash];
case 'Z'
  res = [dash bc dash bc dot bc dot];
case '1'
  res = [dot bc dash bc dash bc dash bc dash];
case '2'
  res = [dot bc dot bc dash bc dash bc dash];
case '3'
  res = [dot bc dot bc dot bc dash bc dash];
case '4'
  res = [dot bc dot bc dot bc dot bc dash];
case '5'
  res = [dot bc dot bc dot bc dot bc dot];
case '6'
  res = [dash bc dot bc dot bc dot bc dot];
case '7'
  res = [dash bc dash bc dot bc dot bc dot];
case '8'
  res = [dash bc dash bc dash bc dot bc dot];
case '9'
  res = [dash bc dash bc dash bc dash bc dot];
case '0'
  res = [dash bc dash bc dash bc dash bc dash];
case '.'
  res = [dot bc dash bc dot bc dash bc dot bc dash];
case ','
  res = [dash bc dash bc dot bc dot bc dash bc dash];
case '?'
  res = [dot bc dot bc dash bc dash bc dot bc dot ];
case '''' 
  res = [dot bc dash bc dash bc dash bc dash bc dot];
case '"'
  res = [dot bc dash bc dot bc dot bc dash bc dot];
case '-' 
  res = [dash bc dot bc dot bc dot bc dot bc dash];
case '('
  res = [dash bc dot bc dash bc dash bc dot bc dash];
case ')'
  res = [dash bc dot bc dash bc dash bc dot bc dash];
case '/'
  res = [dash bc dot bc dot bc dash bc dot];  
case ' '
  res = betweenwords;
otherwise
  res = 0;
end







