function res = averageV2(vec)
% averageV2(vec) --- the arithmetic mean %! Now with error checking
if isempty(vec)
   res = NaN; %! There's a sensible answer
   warning('Empty vector as argument. Returning NaN.');
elseif isnumeric(vec)
   res = sum(vec)./length(vec);
else
   error('Not defined for this type of argument.'); %! No sensible answer.
end
