function res = alphabetcompare(one,two)
% Compares two strings alphabetically, returning
% 1 for a match
% 2 if <one> is before <two>
% 3 if <one> is after <two>

%! Take away blanks
one = one(~isspace(one));
two = two(~isspace(two));

one = lower(one);
%! Convert to lower case
two = lower(two);

for k=1:min(length(one), length(two))
   %! Compare letter-by-letter
   if one(k) < two(k)
      %! ASCII representation has same order as alphabet
      res = 2;
      return;
   elseif one(k) > two(k)
      res = 3;
      return;
   end
end

% They match, up to their lengths
if length(one) == length(two)
   %! They are the same length, so they match
   res = 1;
elseif length(one) < length(two)
   res = 2;
else
   res = 3;
end

   
