% show aliasing
endtime = 1.0;
t = 0:.001:endtime;
freq = 20;
phi = .2;
sampfreqs = [20 21 24 28]; % for aliasing
%sampfreqs = [40 41 42 43]; % for beating
sig = sin(2*pi*freq*t+ phi);

for k=1:length(sampfreqs)
   samptimes = 0:(1/sampfreqs(k)):endtime;
   samps = sin(2*pi*freq*samptimes + phi);
   subplot(length(sampfreqs),1,k);
   h = plot(t,sig,samptimes,samps,'ro-');
   set(h(2), 'LineWidth', 2);
   set(h(1), 'LineWidth', 1);
   if k < length(sampfreqs)
      set(gca, 'XTickLabel', '');
   else
      xlabel('Time (secs)');
   end
   set(gca, 'YTickLabel', '');
   ylim([-1.1 1.1]);
   text(-.15,.5,['1/\Delta T = ' num2str(sampfreqs(k))]);
end

   
   