% simulate sampling from the sine wave
A = 4.5;
f = 2;
phi = -1.4;
t = 0:.001:1.5;
sig = A * sin(2*pi*f*t + phi);

sampperiodlist = [.6, .3, .15, .075, .0375];

for k = 1:length(sampperiodlist)
   subplot(length(sampperiodlist),2,2*k-1);
   samptimes = 0:sampperiodlist(k):1.5;
   samps = A * sin(2*pi*f*samptimes + phi);
      
   finesamp = interp1(samptimes,samps,t);
   handles = plot(t,sig, samptimes, samps, 'o', t, finesamp);
   if k~= length(sampperiodlist)
      set(gca, 'XTickLabel', '');
   else
      xlabel('Time (secs)');
   end
   if k==1
      title('Signal and Interpolated Samples');
   end
   %text(-.5,0,['\Delta T = ' num2str(sampperiodlist(k))]);
   set(handles(3),'LineWidth', 2);
   set(handles(1),'LineWidth', 1);
   
   subplot(length(sampperiodlist),2,2*k);
   plot(t,sig-finesamp);
   if k~= length(sampperiodlist)
      set(gca, 'XTickLabel', '');
   else
      xlabel('Time (secs)');
   end
   
   if k==1
      title('Error between Signal and Interpolation');
   end
   
   
   ylim([-5 5]);
end

