function res = nicecos(angle, units)
% nicecos(angle, units)
% cosine with explicit angle units
% Ex: nicecos(pi, 'radians') or nicecos(180,'degrees')
if nargin == 1
   units = 'radians'; %! The default for units
end

switch lower(units)
case {'radians', 'rad', 'r'}
   res = cos(angle);
case {'degrees', 'deg', 'd'}
   res = cos(pi.*angle./180);
otherwise
   error('Unrecognized units.');
end
