function drawset( set, params )
% drawset( set ) --- draws a set of drawitem graphics commands

% draw the first one
[xmin,ymin,xmax,ymax] = drawthing( set{1}, params );

hold on;
for k=2:length(set)
   [x1,y1,x2,y2] = drawthing(set{k},params);
   xmin = min(xmin,x1);
   ymin = min(ymin,y1);
   xmax = max(xmax,x2);
   ymax = max(ymax,y2);
end

% figure out a good size for the border
% 5 percent of the range on each side
xborder = 0.05*(xmax - xmin);
yborder = 0.05*(ymax - ymin);
axis( [xmin-xborder, xmax+xborder, ymin-yborder, ymax+yborder]);
hold off